/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ApplicationModel;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.scriptconsole.LogConsole;
import org.autoplot.server.RequestListener;
import org.das2.util.LoggerManager;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;

public class RequestHandler {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.server");

    private String untaint(String in, OutputStream out) {
        return in;
    }

    public String handleRequest(InputStream in, ApplicationModel model, OutputStream out, RequestListener rlistener) {
        try {
            String s;
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, model.getDom(), null);
            interp.setOut(out);
            interp.set("params", (PyObject)new PyDictionary());
            interp.set("resourceURI", Py.None);
            model.setPrompt("autoplot> ");
            ScriptContext._setOutputStream(out);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            boolean echo = true;
            if (echo) {
                out.write(model.getPrompt().getBytes());
            }
            while ((s = reader.readLine()) != null) {
                if ((s = this.untaint(s, out)) != null) {
                    s = LogConsole.maybeRemovePrompts(s);
                    logger.log(Level.FINE, "executing command: \"{0}\"", s);
                    if (s.equals("quit") || !rlistener.isListening()) {
                        rlistener.stopListening();
                        break;
                    }
                    try {
                        echo = !s.trim().endsWith(";");
                        interp.exec(JythonRefactory.fixImports((String)s));
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace(new PrintStream(out));
                        ex.printStackTrace();
                    }
                }
                try {
                    if (!echo) continue;
                    out.write(model.getPrompt().getBytes());
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }
}

